<?php

namespace \App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->hasOne('\App\Models\Product\Category');
    }

    public function advertiser()
    {
        return $this->hasOne('\App\Models\Advertiser');
    }

    public function package()
    {
        return $this->belongsToMany('App\Models\Product\Package2', 'product_package_package');
    }

}